package gov.va.med.mhv.usermgmt.persist.ldap;

import netscape.ldap.LDAPException;

public class LdapException extends RuntimeException {
	private String dn;
	
	public LdapException(String message, LDAPException cause) {
		super(message, cause);
	}

	public LdapException(String msg, LDAPException cause, String dn) {
		super(msg + " [dn='" + dn + "']", cause);
		this.dn = dn;
	}
	
	public LdapException(LDAPException cause, String dn) {
		super(dn, cause);
		this.dn = dn;
	}
	
	public String getDn() {
		return dn;
	}
	
	public int getErrorCode() {
		return ((LDAPException)getCause()).getLDAPResultCode();
	}
	
	public String errorCodeToString() {
		return ((LDAPException)getCause()).errorCodeToString();
	}
}